	function  [L, C, W0, K, winv] = LP_LADDER(ZinNum, ZinDen, Rs, RL, G, Z, P, Wc, Ws, Amax, Amin, Type)

	% 	Computes the element values in a lowpass ladder filter with finite zeros
	%	of type a, b or c. Uses the input impedance (ZinNum/ZinDen) 
	%	of the ladder for the synthesis. 
	%
	% 	The element values in a lowpass Chebyshev II LC ladder filter of type a are
	%	 the same as in type c.  
	%
	%	The element values can be improved by polishing, see below.
	%	This part is not activated since it is not needed in most cases.
 
	% 	Toolbox for  DIGITAL FILTERS USING MATLAB 
	
	%	Author: 		Lars Wanhammar 2007-08-26, 2014-11-12
    %	Copyright:		by authors - not released for commercial use					
	%	Modified by: 	LW 2014-04-19 
	%	Version: 		1
	%	Known bugs:		 
	%	Report bugs to:	Wanhammar@gmail.com
	
	Norder = length(P);
	Z1 = Z;
	Z1(imag(Z1) < 0) = [];	%	Remove any "negative" transmission zeros
	Norder = length(P);
	if mod(Norder, 2) == 1	% odd
		Type = 'a';	% Make sure
	else	% even
		Z1 = -flipud(sort(Z1));	% 	Transmission zeros in decending order
		m = length(Z1);
		if Type == 'a'
			Z1 = cat(1,Z1(2:2:m),flipud(Z1(1:2:m)));	% Sort zeros in the right order
		end
		if Type == 'b' | Type == 'c'
			if m > 1
				Z1 = cat(1, Z1(1:2:m), Z1(2:2:m));		% Sort zeros in the right order
			end
		end
	end
	winv = cat(2, -1./Z1.^2', [0]);
	Lx = zeros(length(winv));
	B = Lx;
	for k = 1:length(winv)
		if winv(k) ~= 0
			Den = POLY_AT_X(ZinDen, Z1(k));
			Num = POLY_AT_X(ZinNum, Z1(k));
			Lx(k, 1) = real(Num/(Den*Z1(k)));
			% Compute the shunt inductors, Lshunt = (Zin_prim - Lseries)/2
			N_prim = POLY_AT_X(POLY_PRIM(ZinNum), Z1(k));
			D_prim = POLY_AT_X(POLY_PRIM(ZinDen), Z1(k));
			Z_prim = (N_prim*Den - D_prim*Num)/Den^2;
			Lshunt(k, 1) = real((Z_prim - Lx(k,1))/2);
			B(k, 1) = Lshunt(k, 1)*abs(Z1(k))^2;	%	Compute the shunt capacitor
		else	
			if mod(Norder, 2) == 1
				% odd - % A transmission zero at s = 
				Lx(k, 1) = real(ZinNum(1)/ZinDen(1));	
				B(k, 1) = (ZinNum(3) - Lx(k, 1)*ZinDen(3))/ZinDen(1);
				Lshunt(k, 1) = 0;
			else
				% even - A transmission zero at s = 
				if Type == 'b' | Type == 'c'
					Lx(k, 1) = real(ZinNum(1)/ZinDen(1));
					B(k, 1) = (ZinNum(3) - Lx(k, 1)*ZinDen(3))/ZinDen(1);		
				end
				if Type == 'a'
					Lx(k,1) = real(ZinNum(1)/ZinDen(2));	% A transmission zero at s = 
				end
			end
		end
	end
	%	Perform Amstutz permutations
	for k = 2:length(winv)		% For the remaining transmission zeros
		for m = k:length(winv)	% Combine section m with j where j > m
			for j = m:length(winv)
				U = Lx(m-1, m-1) - Lx(j, k-1);
				V = 1/(U/(B(m-1, m-1)*(winv(j)-winv(m-1))) - 1);
				Lx(j, m) = U*V;
				B(j, m) = B(j, m-1)*(V^2) - B(m-1, m-1)*(1+V)^2;
			end 
		end
	end 
	% Sort the components to fit the function LADDER_2_H
	for j = 1:length(winv)
		L(2*j-1) = Lx(j,j);
		K(2*j-1) = 2;
		C(2*j+1) = 0;
	end
	if mod(Norder, 2) == 1	% odd
		C = zeros(1,Norder);
		for j = 1:length(winv)-1
			C(2*j) = 1/B(j, j);
			L(2*j) = winv(j)*B(j, j);	
			if (L(2*j) == 0)
				K(2*j) = 9;
			else
				K(2*j) = 10;
				W0(2*j) = 1/sqrt(L(2*j)*C(2*j)); % Transmission zeros
			end
		end
		C = C(1:Norder);
		W0 = cat(2, W0, [0]);

	else	% even
		for j = 1:length(winv)	
			C(2*j) = 1/B(j,j);
			if winv(j) == 0
				L(2*j) = 0;
				K(2*j) = 9;
			else
				L(2*j) = winv(j)/C(2*j);
				K(2*j) = 10;
				W0(2*j) = 1/sqrt(L(2*j)*C(2*j)); % Transmission zeros
			end	
		end 
		if Type == 'a'  
			m = length(K); L(m) = []; C(m) = []; K(m) = [];
			disp(['Note - negative element value!']);
		else
			W0 = cat(2, W0, [inf]);
		end
	end
